<!DOCTYPE html>
<html lang="zxx">
<head>
	<title>Zarth Designs</title>
	<meta charset="UTF-8">
	<meta name="description" content="The Plaza eCommerce Template">
	<meta name="keywords" content="plaza, eCommerce, creative, html">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<!-- Favicon -->

	<!-- Google Fonts -->
	<link href="https://fonts.googleapis.com/css?family=Raleway:400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

	<!-- Stylesheets -->
	<link rel="stylesheet" href="css/bootstrap.min.css"/>
	<link rel="stylesheet" href="css/font-awesome.min.css"/>
	<link rel="stylesheet" href="css/owl.carousel.css"/>
	<link rel="stylesheet" href="css/style.css"/>
	<link rel="stylesheet" href="css/animate.css"/>


	<!--[if lt IE 9]>
	  <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
	  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
	<![endif]-->

	<style type="text/css">
		body
		{
			background: #f4d6d8;
			color: #300a0c;
		}
		.custom-logo
		{
			font-family: Kunstler Script;
			color: #eec4c7;
			font-size: 100px;
			cursor: pointer;
		}
		/* Full-screen video container */
        #hero-video-container {
            position: relative;
            overflow: hidden;
            width: 100%;
            height: 100vh;
        }
        
        /* Video element */
        #hero-video {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        /* Navigation styles */
        nav {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            background-color: rgba(0, 0, 0, 0);
            padding: 10px;
        }
        
        nav ul {
            list-style: none;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
        }
        
        nav ul li {
            margin: 0 10px;
        }
        
        nav ul li a {
            color: #fff;
            text-decoration: none;
            font-weight: bold;
        }
        /* Overlay */
        #overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
           	background-color: rgba(0, 0, 0, 0.5); /* Transparent navy overlay */
        }
        #instructions {
            position: absolute;
            top: 70%;
            left: 50%;
            transform: translate(-50%, -50%);
            text-align: center;
            color: #fff;
        }
        #instructions h3, p {

        	color: #fff;
        }
        #instructions a
        {
        	color: #333;
        	background: #fff;
        	padding: .5em 1em;
        	border: none;
        	cursor: pointer;
        }
        #instructions a:hover
        {
        	background: #333;
        	color: #fff;
        }
        #rightsSwipe
        {
        	position: absolute;
        	top: 50%;
        	left: 90%;
        	cursor: pointer;
     		color: #fff;
     		font-size: 3em;
        }
        #leftSwipe
        {
        	position: absolute;
        	top: 50%;
        	right: 90%;
        	cursor: pointer;
        	color: #fff;
        	font-size: 3em;
        }
        .Subscribe
        {
        	background: #f4d6d8;
        	padding: .5em;
        	width: 55%;
        	//text-align: center !important;
        }
        .Subscribe input
        {
        	background: #f4d6d8;
        	border: none;
        	padding: .5em;
        	//padding-right: 12em;
        	width: 75%;
        	border-bottom: 2px dotted #000;
        	margin-right: 20px;
        }
        .Subscribe button
        {
        	background: #fff;
        	border: none;
        	padding: .5em 1.5em;
        	font-weight: 2.5em;
        	cursor: pointer;
        }
        .news-letter h3
        {
        	//text-align: center;
        	margin-bottom: .5em;
        }
        .news-letter p
        {
        	color: #333;
        	text-align: center;
        	margin-bottom: 4.5em;
        }
        .news-letter
        {
        	//text-align: center;
        }
        @media  screen and (max-width:800px){
       
	       .Subscribe input
        	{
	        	width: 100%;
	        	margin-bottom: 1em;
        	}
        	.Subscribe
	        {
	        	width: 100%;
	        	//text-align: center !important;
	        }
	        .container2{
	        	width: 100%;
	        }
	        .custom-logo
	        {
	        	font-size: 50px;
	        }
       }

       .main-menu{
       	font-family: Orator Std !important;
       }
       .product-section
       {
       		font-family: Orator Std !important;
       }
       .footer-top-section
       {
       		font-family: Orator Std !important;
       }
       footer
       {
       		font-family: Orator Std !important;
       }
	</style>

</head>
<body>
	<!-- Page Preloder -->
	<div id="preloder">
		<div class="loader"></div>
	</div>
	
	<!-- Header section -->
	<header class="header-section">
		<div class="container-fluid">
			<!-- logo -->
			<div class="site-logo">
				<!--<img src="img/logo.png" height="100" alt="logo">--><span class="custom-logo">ZR</span>
			</div>
			<!-- responsive -->
			<div class="nav-switch">
				<i class="fa fa-bars"></i>
			</div>
			<div class="header-right">
				<a href="/cart" class="card-bag"><img src="img/icons/bag.png" alt=""><span><?php echo e(Cart::count()); ?></span></a>
				<a href="#" class="search"><img src="img/icons/search.png" alt=""></a>
			</div>
			<!-- site menu -->
			<ul class="main-menu">
				<li><a href="/">Home</a></li>
				<li><a href="3">Woman</a></li>
				<li><a href="#">Man</a></li>
				<li><a href="#">LookBook</a></li>
				<li><a href="#">Blog</a></li>
				<li><a href="#">Contact</a></li>
			</ul>
		</div>
	</header>
	<!-- Header section end -->


	<!-- Hero section -->
	<div id="hero-video-container">
        <video id="hero-video" autoplay loop muted>
            <source src="img/Bella Hadid & Kendall Jenner walk for Off-White.mp4" type="video/mp4">
            <source src="img/video2.mp4" type="video/mp4">
            <source src="img/video3.mp4" type="video/mp4">
            <!-- Fallback content if video isn't supported -->
            Your browser does not support the video tag.
        </video>
        <div id="overlay"></div>
        <div id="instructions">
            <h3>Welcome to Zarth Designs</h3>
            <p>Discover Amazing fashion and More</p>
            <a href="/products">Shop Now</a>
        </div>
        <div>
        	<p id="rightsSwipe"></p>
        	<p id="leftSwipe"></p>
        </div>
        <button id="call-to-action">Call to Action</button>
    </div>
	<!-- Hero section end -->

	
	<!-- Intro section -->
	<section class="intro-section spad pb-0">
		<div class="section-title">
			<h2>pemium products</h2>
		</div>
		<div class="intro-slider">
			<ul class="slidee">
				
				<?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<li>
						<div class="intro-item">
							<figure>
								<img src="img/event/11898561_659660650800877_8147975474581652420_n.jpg" alt="#">
								<div class="bache">NEW</div>
							</figure>
							<div class="product-info">
								<h5><?php echo e($product->Title); ?></h5>
								<p>R<?php echo e($product->Price); ?></p>
								<a href="#" class="site-btn btn-line">ADD TO CART</a>
							</div>
						</div>
					</li>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				
			</ul>
		</div>
	</section>
	<!-- Intro section end -->


	<!-- Featured section -->
	<div class="featured-section spad">
		<div class="container">
			<div class="row">
				<div class="col-md-6">
					<div class="featured-item">
						<img src="img/event/11215715_659660777467531_6819123739934146602_n.jpg" alt="">
						<a href="#" class="site-btn">see more</a>
					</div>
				</div>
				<div class="col-md-6">
					<div class="featured-item mb-0">
						<img src="img/event/11903823_659660800800862_6223709383144650447_n.jpg" alt="">
						<a href="#" class="site-btn">see more</a>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- Featured section end -->


	<!-- Product section -->
	<section class="product-section spad">
		<div class="container">
			<ul class="product-filter controls">
				<li class="control" data-filter=".new">New arrivals</li>
				<li class="control" data-filter="all">Recommended</li>
				<li class="control" data-filter=".best">Best sellers</li>
			</ul>
			<div class="row" id="product-filter">

				<?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<div class="mix col-lg-3 col-md-6 best">
						<a href="/product/<?php echo e($product->id); ?>">
							<div class="product-item">
								<figure>
									<img src="<?php echo e(asset($product->image)); ?>" alt="">
									<div class="pi-meta">
										<div class="pi-m-left">
											<img src="img/icons/eye.png" alt="">
											<p>quick view</p>
										</div>
										<div class="pi-m-right">
											<img src="img/icons/heart.png" alt="">
											<p>save</p>
										</div>
									</div>
								</figure>
								<div class="product-info">
									<p><?php echo e($product->Title); ?> -<b>R<?php echo e($product->Price); ?></b></p>
									<!--<a href="#" class="site-btn btn-line">ADD TO CART</a>-->
								</div>
							</div>
						</a>
					</div>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

			</div>
		</div>
	</section>
	<!-- Product section end -->


	<!-- Blog section -->	
	<section class="blog-section spad">
		<div class="container">
			<div class="news-letter">
				<h3>Subscribe to our news letter</h3>
				<!--<p>latest releases deals and sales.</p>-->

				<div>
					<div class="Subscribe">
						<input type="email" name="email" placeholder="Your Email"> <button>Subscribe</button>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Blog section end -->	


	<!-- Footer top section -->	
	<section class="footer-top-section home-footer">
		<div class="container">
			<div class="row">
				<div class="col-lg-3 col-md-8 col-sm-12">
					<div class="footer-widget about-widget">
						<img src="img/logo.png" class="footer-logo" alt="" height="100">
						<p>Donec vitae purus nunc. Morbi faucibus erat sit amet congue mattis. Nullam fringilla faucibus urna, id dapibus erat iaculis ut. Integer ac sem.</p>
						<div class="cards">
							<img src="img/cards/5.png" alt="">
							<img src="img/cards/4.png" alt="">
							<img src="img/cards/3.png" alt="">
							<img src="img/cards/2.png" alt="">
							<img src="img/cards/1.png" alt="">
						</div>
					</div>
				</div>
				<div class="col-lg-2 col-md-4 col-sm-6">
					<div class="footer-widget">
						<h6 class="fw-title">usefull Links</h6>
						<ul>
							<li><a href="#">Partners</a></li>
							<li><a href="#">Bloggers</a></li>
							<li><a href="#">Support</a></li>
							<li><a href="#">Terms of Use</a></li>
							<li><a href="#">Press</a></li>
						</ul>
					</div>
				</div>
				<div class="col-lg-2 col-md-4 col-sm-6">
					<div class="footer-widget">
						<h6 class="fw-title">Sitemap</h6>
						<ul>
							<li><a href="#">Partners</a></li>
							<li><a href="#">Bloggers</a></li>
							<li><a href="#">Support</a></li>
							<li><a href="#">Terms of Use</a></li>
							<li><a href="#">Press</a></li>
						</ul>
					</div>
				</div>
				<div class="col-lg-2 col-md-4 col-sm-6">
					<div class="footer-widget">
						<h6 class="fw-title">Shipping & returns</h6>
						<ul>
							<li><a href="#">About Us</a></li>
							<li><a href="#">Track Orders</a></li>
							<li><a href="#">Returns</a></li>
							<li><a href="#">Jobs</a></li>
							<li><a href="#">Shipping</a></li>
							<li><a href="#">Blog</a></li>
						</ul>
					</div>
				</div>
				<div class="col-lg-2 col-md-4 col-sm-6">
					<div class="footer-widget">
						<h6 class="fw-title">Contact</h6>
						<div class="text-box">
							<p>Zarth Designs</p>
							<p>87 Smiso Nkwanyana Rd, Morningside, Durban, 4001</p>
							<p>031 303 4020</p>
							<p>office@youremail.com</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Footer top section end -->	

		<!-- Footer section -->
	<footer class="footer-section">
		<div class="container">
			<p class="copyright">
<!-- Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. -->
Zarth Designs &copy; <script>document.write(new Date().getFullYear());</script> All rights reserved | Website designed by <a href="#" target="_blank">I Tek Solutions</a>
<!-- Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. -->
</p>
		</div>
	</footer>
	<!-- Footer section end -->


	<!--====== Javascripts & Jquery ======-->
	<script src="js/jquery-3.2.1.min.js"></script>
	<script src="js/bootstrap.min.js"></script>
	<script src="js/owl.carousel.min.js"></script>
	<script src="js/mixitup.min.js"></script>
	<script src="js/sly.min.js"></script>
	<script src="js/jquery.nicescroll.min.js"></script>
	<script src="js/main.js"></script>
    </body>
</html><?php /**PATH C:\xampp\htdocs\example-app\resources\views/home.blade.php ENDPATH**/ ?>